@extends('layouts.app')
@section('title', __('lang_v1.product_purchase_report'))
@section('content')
<section class="content-header">
  <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">
    {{ __('lang_v1.product_purchase_report') }}
  </h1>
</section>
<section class="content">
  <div class="row">
    <div class="col-md-12">
      @component('components.filters', ['title' => __('report.filters')])
      {!! Form::open(['url' => action([\App\Http\Controllers\ReportController::class, 'getStockReport']), 'method' => 'get', 'id' => 'product_purchase_report_form']) !!}
        <div class="row">
          <div class="col-md-3">
            <div class="form-group">
              {!! Form::label('search_product', __('lang_v1.search_product') . ':') !!}
              <div class="input-group">
                <span class="input-group-addon"><i class="fa fa-search"></i></span>
                <input type="hidden" id="variation_id" value="">
                {!! Form::text('search_product', null, ['class' => 'form-control', 'id' => 'search_product', 'placeholder' => __('lang_v1.search_product_placeholder'), 'autofocus']) !!}
              </div>
            </div>
          </div>
          <div class="col-md-3">
            <div class="form-group">
              {!! Form::label('supplier_id', __('purchase.supplier') . ':') !!}
              <div class="input-group">
                <span class="input-group-addon"><i class="fa fa-user"></i></span>
                {!! Form::select('supplier_id', $suppliers, null, ['class' => 'form-control select2', 'style' => 'width:100%;', 'placeholder' => __('messages.please_select'), 'id' => 'supplier_id']) !!}
              </div>
            </div>
          </div>
          <div class="col-md-3">
            <div class="form-group">
              {!! Form::label('location_id', __('purchase.business_location') . ':') !!}
              <div class="input-group">
                <span class="input-group-addon"><i class="fa fa-map-marker"></i></span>
                {!! Form::select('location_id', $business_locations, null, ['class' => 'form-control select2', 'style' => 'width:100%;', 'placeholder' => __('messages.please_select'), 'id' => 'location_id']) !!}
              </div>
            </div>
          </div>
          <div class="col-md-3">
            <div class="form-group">
              {!! Form::label('product_pr_date_filter', __('report.date_range') . ':') !!}
              {!! Form::text('date_range', null, ['placeholder' => __('lang_v1.select_a_date_range'), 'class' => 'form-control', 'id' => 'product_pr_date_filter', 'readonly']) !!}
            </div>
          </div>
          <div class="col-md-3">
            <div class="form-group">
              {!! Form::label('ppr_brand_id', __('product.brand').':') !!}
              {!! Form::select('ppr_brand_id', $brands, null, ['class' => 'form-control select2', 'style' => 'width:100%;', 'placeholder' => __('lang_v1.all'), 'id' => 'ppr_brand_id']) !!}
            </div>
          </div>
        </div>
      {!! Form::close() !!}
      @endcomponent
    </div>
  </div>

  <div class="row">
    <div class="col-md-12">
      @component('components.widget', ['class' => 'box-primary'])
        <div class="table-responsive">
          <table class="table table-bordered table-striped" id="product_purchase_report_table">
            <thead>
              <tr>
                <th>@lang('sale.product')</th>
                <th>@lang('product.sku')</th>
                <th>Lot Number</th>
                <th>Expiration Date</th>
                <th>@lang('purchase.supplier')</th>
                <th>{{ __('business.business_location') }}</th>
                <th>@lang('purchase.ref_no')</th>
                <th>@lang('messages.date')</th>
                <th>@lang('sale.qty')</th>
                <th>@lang('lang_v1.total_unit_adjusted')</th>
                <th>@lang('lang_v1.unit_perchase_price')</th>
                <th>@lang('sale.subtotal')</th>
              </tr>
            </thead>
            <tfoot>
              <tr class="bg-gray font-17 footer-total text-center">
                <td colspan="8"><strong>@lang('sale.total'):</strong></td>
                <td id="footer_total_purchase"></td>
                <td id="footer_total_adjusted"></td>
                <td></td>
                <td><span class="display_currency" id="footer_subtotal" data-currency_symbol="true"></span></td>
              </tr>
            </tfoot>
          </table>
        </div>
      @endcomponent
    </div>
  </div>
</section>

<div class="modal fade view_register" tabindex="-1" role="dialog" aria-labelledby="gridSystemModalLabel"></div>
@endsection

@section('javascript')
<script>
(function(){
  'use strict';

  var blMap = @json(collect($business_locations)->mapWithKeys(fn($n,$id)=>[$id=>$n]));
  var purchaseShowBase = "{{ url('purchases') }}/";

  function parseQtyUnit(val){
    if (val && typeof val === 'object') {
      if ('quantity_adjusted' in val) return { n: parseFloat(val.quantity_adjusted)||0, u: (val.unit||'').trim() };
      if ('purchase_qty' in val && typeof val.purchase_qty === 'string') {
        var m = val.purchase_qty.match(/([\d.,-]+)\s*([A-Za-z()\/]+)?/);
        if (m) return { n: parseFloat(m[1].replace(/,/g,''))||0, u: (m[2]||'').trim() };
      }
    }
    var s = String(val||'').trim(), m = s.match(/([\d.,-]+)\s*([A-Za-z()\/]+)?/);
    if (!m) return null;
    return { n: parseFloat(m[1].replace(/,/g,''))||0, u: (m[2]||'').trim() };
  }
  function sumColumnByUnit(api, colIdx, targetSelector){
    var map = {};
    api.column(colIdx, {page:'current'}).data().each(function(v){
      var p = parseQtyUnit(v); if (!p) return;
      map[p.u] = (map[p.u]||0) + p.n;
    });
    var out = Object.keys(map).map(function(u){
      return (map[u]).toLocaleString(undefined,{maximumFractionDigits:2}) + (u ? (' ' + u) : '');
    }).join(', ');
    $(targetSelector).html(out || '0');
  }
  function parseMoney(txt){ if (txt == null) return 0; txt = String(txt).replace(/[^\d.,-]/g,''); return parseFloat(txt.replace(/,/g,'')) || 0; }
  function sumSubtotalFromCells(api, colIdx){
    var total = 0;
    api.cells(null, colIdx, { page: 'current' }).every(function(){
      var node = this.node(); var text = node && node.textContent ? node.textContent : '';
      total += parseMoney(text);
    });
    return total;
  }
  function setFooterCurrency($el, amount){
    if (typeof __currency_trans_from_en === 'function') { $el.html(__currency_trans_from_en(amount, true)); }
    else { $el.text(amount.toLocaleString(undefined,{minimumFractionDigits:2, maximumFractionDigits:2})); }
  }

  if ($.fn.select2) { $('#supplier_id,#location_id,#ppr_brand_id').select2({width:'100%'}); }

  // Date range picker setup
  var drPicker, mf = (window.moment_date_format || 'MM/DD/YYYY');
  if ($.fn.daterangepicker) {
    var drs = window.dateRangeSettings || {
      startDate: moment().startOf('month'),
      endDate: moment().endOf('month')
    };
    $('#product_pr_date_filter').daterangepicker(drs, function(start, end){
      $('#product_pr_date_filter').val(start.format(mf) + ' - ' + end.format(mf)).trigger('change');
    });
    drPicker = $('#product_pr_date_filter').data('daterangepicker');

    $('#product_pr_date_filter')
      .on('apply.daterangepicker', function(ev, picker){
        $(this).val(picker.startDate.format(mf)+' - '+picker.endDate.format(mf)).trigger('change');
      })
      .on('cancel.daterangepicker', function(){
        $(this).val('').trigger('change');
      });
  }

  // Initialize DataTable
  var table = $('#product_purchase_report_table').DataTable({
    processing:true, serverSide:true, searching:true, lengthChange:true,
    dom:
      "<'row'<'col-sm-3'l><'col-sm-6 text-center'B><'col-sm-3'f>>" +
      "tr" +
      "<'row'<'col-sm-6'i><'col-sm-6'p>>",
    buttons:[
      { extend:'csvHtml5',   text:'<i class=\"fa fa-file-text-o\"></i> Export CSV',    title:'Product Purchase Report', exportOptions:{columns:':visible'} },
      { extend:'excelHtml5', text:'<i class=\"fa fa-file-excel-o\"></i> Export Excel', title:'Product Purchase Report', exportOptions:{columns:':visible'} },
      { extend:'print',      text:'<i class=\"fa fa-print\"></i> Print',               title:'Product Purchase Report', exportOptions:{columns:':visible'} },
      { extend:'colvis',     text:'<i class=\"fa fa-columns\"></i> Column visibility' },
      { extend:'pdfHtml5',   text:'<i class=\"fa fa-file-pdf-o\"></i> Export PDF',     title:'Product Purchase Report', orientation:'landscape', pageSize:'A4', exportOptions:{columns:':visible'} }
    ],

    // ⬇️ Added: include “ALL” in the length dropdown
    lengthMenu: [[10, 25, 50, 100, -1], [10, 25, 50, 100, 'ALL']],
    pageLength:25,

    order:[[7,'desc']], // date column
    ajax:{
      url:"{{ action([\App\Http\Controllers\ReportController::class, 'getproductPurchaseReport']) }}",
      data:function(d){
        var val = $('#product_pr_date_filter').val();
        var start = '', end = '';
        if (drPicker && drPicker.startDate && drPicker.endDate && val) {
          start = drPicker.startDate.format('YYYY-MM-DD');
          end   = drPicker.endDate.format('YYYY-MM-DD');
        } else if (val) {
          var parts = val.split(' - ');
          if (parts.length === 2) {
            start = moment(parts[0], mf).format('YYYY-MM-DD');
            end   = moment(parts[1], mf).format('YYYY-MM-DD');
          }
        }
        d.start_date = start;
        d.end_date   = end;
        d.date_range = val || '';

        // Send filter params
        d.search_product = $('#search_product').val() || '';
        d.variation_id   = $('#variation_id').val() || '';
        d.supplier_id    = $('#supplier_id').val() || '';
        d.location_id    = $('#location_id').val() || '';
        d.brand_id       = $('#ppr_brand_id').val() || '';

        console.log('Filter params:', {
          search_product: d.search_product,
          variation_id: d.variation_id,
          supplier_id: d.supplier_id,
          location_id: d.location_id,
          brand_id: d.brand_id
        });
      }
    },
    columns:[
      { data:'product_name', name:'p.name' },
      { data:'sub_sku', name:'v.sub_sku' },
      { data:'lot_number', orderable:false, searchable:false },
      { data:'expiration_date', orderable:false, searchable:false },
      { data:'supplier', name:'c.supplier_business_name',
        render:function(d){ d=(d||'').toString().trim(); return d!==''?d:'-'; }
      },
      { data:'location_id', name:'t.location_id',
        render:function(d){ return (d && blMap[d])? blMap[d]:'-'; }
      },
      { data:'ref_no', name:'t.ref_no',
        render:function(data,type,row){
          var href = purchaseShowBase + row.transaction_id;
          return '<a href="#" class="btn-modal" data-container=".view_register" data-href="'+href+'">'+(data||'')+'</a>';
        }
      },
      { data:'transaction_date', name:'t.transaction_date' },
      { data:'purchase_qty', orderable:false, searchable:false },
      { data:null, orderable:false, searchable:false,
        render:function(d,t,row){
          var q=parseFloat(row.quantity_adjusted||0), u=row.unit||'';
          return (isFinite(q)?q:0).toLocaleString(undefined,{maximumFractionDigits:2}) + (u?(' '+u):'');
        }
      },
      { data:'unit_purchase_price', name:'purchase_lines.purchase_price_inc_tax', orderable:false, searchable:false },
      { data:'subtotal', orderable:false, searchable:false }
    ],
    initComplete:function(){ window.product_purchase_report_table = this.api(); },
    drawCallback:function(s){
      var api = this.api();
      if(typeof __currency_convert_recursively==='function'){
        __currency_convert_recursively($('#product_purchase_report_table'));
      }
      if (s && s.json && s.json.footer_subtotal) {
        $('#footer_subtotal').html(s.json.footer_subtotal);
      } else {
        var subtotal = sumSubtotalFromCells(api, 11);
        setFooterCurrency($('#footer_subtotal'), subtotal);
      }
      sumColumnByUnit(api, 8, '#footer_total_purchase');
      sumColumnByUnit(api, 9, '#footer_total_adjusted');
    }
  });

  // Reload on filter change
  var debounce = (window._ && _.debounce) ? _.debounce : function(fn, wait){var t;return function(){clearTimeout(t);var a=arguments,c=this;t=setTimeout(function(){fn.apply(c,a);},wait||300);};};
  $('#product_pr_date_filter').on('change', function(){ table.ajax.reload(); });
  $('#search_product').on('input', debounce(function(){
    if(!this.value) $('#variation_id').val('');
    table.search(this.value).draw();
  }, 300));
  $(document).on('change','#supplier_id,#location_id,#ppr_brand_id',function(){ table.ajax.reload(); });

})();
</script>
@endsection
